
#ifndef uPARinitializerClusterSteppable_H
#define uPARinitializerClusterSteppable_H

#include <CompuCell3D/plugins/NeighborTracker/NeighborTrackerPlugin.h>
#include <CompuCell3D/plugins/PixelTracker/BoundaryPixelTrackerPlugin.h>
#include <CompuCell3D/plugins/PixelTracker/PixelTrackerPlugin.h>
#include <CompuCell3D/Potts3D/EnergyFunction.h>
#include <CompuCell3D/Potts3D/Cell.h>
#include <CompuCell3D/Potts3D/Potts3D.h>
#include <CompuCell3D/Potts3D/CellGChangeWatcher.h>
#include <CompuCell3D/Steppable.h>
#include <CompuCell3D/Field3D/Dim3D.h>
#include <CompuCell3D/Field3D/Field3D.h>
#include <CompuCell3D/Field3D/WatchableField3D.h>

#include <string>
#include <BasicUtils/BasicRandomNumberGenerator.h>


#include <CompuCell3D/Steppable.h>
#include <CompuCell3D/Field3D/Dim3D.h>
#include <CompuCell3D/Field3D/Point3D.h>

#include <BasicUtils/BasicClassAccessor.h>

#include "../ClusterDataTrackerPlugin/ClusterDataTrackerPlugin.h"
#include "ClusterData.h"


//STL containers
#include <vector>
#include <list>
#include <set>
#include <map>

template <typename Y> class BasicClassAccessor;
namespace CompuCell3D {
    

  template <class T> class WatchableField3D;
  template <class T> class Field3DImpl;

    class ClusterData;  
    class Potts3D;
    class Automaton;
    class BoundaryStrategy;
    class CellInventory;
    class CellG;
    class Simulator;
    class BoundaryPixelTrackerPlugin;
    class PixelTrackerPlugin;
    //class NeighborTrackerPlugin;
   
        
  class  uPARinitializerClusterSteppable : public Steppable {
    WatchableField3D<CellG *> *fieldG;
    Simulator * sim;
    Potts3D *potts;
    CC3DXMLElement *xmlData;
    Automaton *automaton;
    BoundaryStrategy *boundaryStrategy;
    CellInventory * cellInventoryPtr;  	
    Dim3D fieldDim;
      
    BasicRandomNumberGenerator * rand; 
    unsigned int maxNeighborIndex;
    
    Field3D<float> *FuPAR;
    

  public:

        double uPARinitPericyte;
        double uPARinitEC;
        float deltainitEC;
        float notchinitEC;
        float VEGFR2initEC;
        double randomPercentage;

        Field3DImpl<float>* getCCFieldByName(std::string _fieldName);
        //BasicClassAccessor<NeighborTracker> * neighborTrackerAccessorPtr;
        //NeighborTrackerPlugin *nTrackerPlugin;
        BasicClassAccessor <BoundaryPixelTracker> *bptAccessorPtr;
	BoundaryPixelTrackerPlugin *boundaryPixelTrackerPlugin;
        
        BasicClassAccessor <ClusterDataTrackerPlugin> *clusterDataTrackerAccessorPtr;
	ClusterDataTrackerPlugin *clusterDataTrackerPlugin;
        
        BasicClassAccessor <PixelTracker> *pixelTrackerAccessorPtr;
	PixelTrackerPlugin *pixelTrackerPlugin;
        
	BasicClassAccessor <ClusterData> 
	clusterDataAccessor;
        
    //functions
    set<Point3D> returnUPARpixels(CellG *cell,set<Point3D> membranePixelList);         
    
    uPARinitializerClusterSteppable ();
    virtual ~uPARinitializerClusterSteppable ();
    // SimObject interface
    virtual void init(Simulator *simulator, CC3DXMLElement *_xmlData=0);
    virtual void extraInit(Simulator *simulator);

    //steppable interface
    virtual void start();
    virtual void step(const unsigned int currentStep);
    virtual void finish() {}


    //SteerableObject interface
    virtual void update(CC3DXMLElement *_xmlData, bool _fullInitFlag=false);
    virtual std::string steerableName();
	 virtual std::string toString();
   

      protected:
    /**
     * @return The index used for ordering contact energies in the map.
     */

  };
};
#endif        
